/*** 1.   ũƮ ***/

SELECT CASE WHEN RIGHT(CONVERT(VARCHAR,a.number),1) <= 8 THEN 'A' ELSE 'B' END ID
	, CONVERT(VARCHAR,a.number) ProductNumber 
	, CONVERT(VARCHAR,b.number) CatalogNumber
	, CONVERT(DATE,DATEADD(dd,a.number,'2015-01-01'),0) ModifiedDate
INTO TB_PartitionDelete
FROM master..spt_values a, (SELECT number 
			     FROM master..spt_values 
			     WHERE type = 'P') b 
WHERE a.type = 'P'

CREATE CLUSTERED INDEX CIDX_PartitionDelete ON TB_PartitionDelete(ModifiedDate)
GO


/*** 2. [AS-IS] SQL    ȹ ***/

DELETE 
FROM TB_PartitionDelete
WHERE ModifiedDate BETWEEN '2015-01-01' AND '2016-01-01'
GO


/*** 6. [TO-BE]   ***/

--̺  
-- Ŭ ε 
DROP INDEX CIDX_PartitionDelete ON TB_PartitionDelete

--Ƽ Լ 
CREATE PARTITION FUNCTION [Partition_FN_TB_PD](date) 
AS RANGE LEFT FOR VALUES (N'2016-01-01', N'2017-01-01', N'2018-01-01', 
			   N'2019-01-01', N'2020-01-01')

--Ƽ ǥ  
CREATE PARTITION SCHEME [Partition_Scheme_TB_PD] 
AS PARTITION [Partition_FN_TB_PD] TO ([PRIMARY], [PRIMARY], [PRIMARY], 
				      [PRIMARY], [PRIMARY], [PRIMARY])

--Ŭ ε Ƽ Ͽ 
CREATE CLUSTERED INDEX CIDX_PartitionDelete ON TB_PartitionDelete(ModifiedDate) 
					   ON Partition_Scheme_TB_PD(ModifiedDate)
GO

--  ġ ̺ 
CREATE TABLE TB_DeletePD (ID VARCHAR NOT NULL
	, ProductNumber VARCHAR(30)
	, CatalogNumber VARCHAR(30)
	, ModifiedDate DATE) 

CREATE CLUSTERED INDEX CIDX_DeletePD ON TB_DeletePD(ModifiedDate) 
ON Partition_Scheme_TB_PD(ModifiedDate)
GO

--SQL  
--   Ī [TB_PartitionDelete] -> [TB_DeletePD]
ALTER TABLE TB_PartitionDelete SWITCH PARTITION 1 TO TB_DeletePD PARTITION 1

--Ī  
TRUNCATE TABLE TB_DeletePD

-- Ƽ 
ALTER PARTITION FUNCTION Partition_FN_TB_PD() MERGE RANGE ('2016-01-01')
GO
